﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace KursBeispiele
{
    public delegate double DoCalc(double x);

    public partial class Form1 : Form
    {
        List<string> eineListe;
        DoCalc calc;

        public Form1()
        {
            InitializeComponent();
            comboBox1.SelectedIndex = 0;

            //Sehr leichtes Listenmanagement:
            eineListe = new List<string>();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //Fügt den Text zur Liste hinzu
            eineListe.Add(textBox1.Text);

            textBox1.Text = string.Empty;
        }

        //Wir wollen keine leeren Texte in der Liste haben!
        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            button1.Enabled = !textBox1.Text.Equals(string.Empty);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //hier leeren wir die Liste
            listBox1.Items.Clear();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            //hier leeren wir die Liste und fügen alle Einträge unserer Liste hinzu
            button2_Click(sender, e);
            listBox1.Items.AddRange(eineListe.ToArray());
        }

        private void button4_Click(object sender, EventArgs e)
        {
            //Wir verwenden hier nur Funktionen der Math Klasse
            double input = (double)numericUpDown1.Value;
            //Hier wird ein delegate wie vorhin schon verwendet
            double result = calc(input);
            MessageBox.Show(result.ToString("0.000"), "Ergebnis");
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            //Setzen des Delegaten
            switch (comboBox1.SelectedIndex)
            {
                case 0:
                    calc = new DoCalc(Math.Sin);
                    break;
                case 1:
                    calc = new DoCalc(Math.Cos);
                    break;
                case 2:
                    calc = new DoCalc(Math.Exp);
                    break;
                default:
                    calc = new DoCalc(Math.Abs);
                    break;
            }
        }

        //Auslesen der Prozesse
        private void button5_Click(object sender, EventArgs e)
        {
            List<string> names = new List<string>();

            //Beispielsweise könnten wir einfach den Prozessnamen hinzufügen
            foreach (Process p in Process.GetProcesses())
                names.Add(p.ProcessName);

            //Liste wieder leeren und neu setzen
            button2_Click(sender, e);
            listBox1.Items.AddRange(names.ToArray());
        }
    }
}
